<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (Schema::hasTable('ai_messages') && !Schema::hasColumn('ai_messages', 'rating')) {
            Schema::table('ai_messages', function (Blueprint $table) {
                $table->tinyInteger('rating')->nullable()->after('ok');
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasTable('ai_messages') && Schema::hasColumn('ai_messages', 'rating')) {
            Schema::table('ai_messages', function (Blueprint $table) {
                $table->dropColumn('rating');
            });
        }
    }
};

